* set wd
cd " "
clear
use "VOTER_Survey_Jan217_Release1-dta.dta"

*ID variable
gen id=_n

*How much of the time trust the government in Washington to do what is right? About always - most of the time - (only) some of the time
recode trustgovt_2019 trustgovt_2018 trustgovt_2017 trustgovt_2016 (8 9=.) (1=3) (2=2) (3=1)

*Gender
recode gender_baseline (8 9=.),gen(gender_2016)
gen gender_2017=gender_2016

*Age
recode birthyr_baseline (9998 9999=.),gen(born)
replace born=birthyr_2018 if born==.
replace born=birthyr_2019 if born==.

gen age_2016=2016-born
gen age_2017=2017-born
gen age_2018=2018-born
gen age_2019=2019-born

*Education
recode educ_2016 (1=1) (2 3=2) (4 5 6=3) (8=.),gen(edu_2016)
recode educ_2017 (1=1) (2 3=2) (4 5 6=3) (8=.),gen(edu_2017)
recode educ_2018 (1=1) (2 3=2) (4 5 6=3) (8=.),gen(edu_2018)
recode educ_2019 (1=1) (2 3=2) (4 5 6=3) (8=.),gen(edu_2019)

*Family income (categories are consistent between waves)
recode faminc_2016 faminc_new_2017 faminc_new_2018 faminc_new_2019 (97 98=.)
rename faminc_new_2017 faminc_2017
rename faminc_new_2018 faminc_2018
rename faminc_new_2019 faminc_2019

xtile income_2016=faminc_2016,n(5)
xtile income_2017=faminc_2017,n(5)
xtile income_2018=faminc_2018,n(5)
xtile income_2019=faminc_2019,n(5)

*Employment status
recode employ_2016 (1 2=1) (98=.) (nonmis=0),gen(workstatus_2016)
gen employ_2017=.
gen workstatus_2017=.

recode employ_2018 (1 2=1) (98=.) (nonmis=0),gen(workstatus_2018)
recode employ_2019 (1 2=1) (98=.) (nonmis=0),gen(workstatus_2019)

*Political interest: Would you say you follow what's going on in government and public affairs... most of the time - some of the time - only now and then - hardly at all
recode newsint_2016 (1=4) (2=3) (3=2) (4=1) (7 8=.), gen(polint_2016)
recode newsint_2017 (1=4) (2=3) (3=2) (4=1) (7 8=.), gen(polint_2017)
recode newsint_2018 (1=4) (2=3) (3=2) (4=1) (7 8=.), gen(polint_2018)
recode newsint_2019 (1=4) (2=3) (3=2) (4=1) (7 8=.), gen(polint_2019)

*Ideology - 5-point scale: very liberal - liberal - moderate - conservative - very conservative
recode ideo5_2016 (6 8=.),gen(leftright_2016)
recode ideo5_2017 (6 8=.),gen(leftright_2017)
recode ideo5_2018 (6 8=.),gen(leftright_2018)
recode ideo5_2019 (6 8=.),gen(leftright_2019)

*SWD - only in two waves
gen demsat_2016=.
recode us_democracy_satisfaction_2017 (1=4) (2=3) (3=2) (4=1) (8 9=.),gen(demsat_2017)
recode satisf_dem_2018 (1=4) (2=3) (3=2) (4=1) (8 9=.),gen(demsat_2018)
gen demsat_2019=.

save "US_VSG_Panel_1620.dta",replace

*Reshape to long
reshape long trustgovt_ gender_ age_ educ_ edu_ faminc_ income_ employ_ workstatus_ polint_ leftright_ demsat_, i(id) j(year)

rename trustgovt_ trustgovt
rename gender_ gender
rename age_ age
rename educ_ educ
rename edu_ edu
rename faminc_ faminc
rename income_ income 
rename employ_ employ
rename workstatus_ workstatus
rename polint_ polint
rename leftright_ leftright
rename demsat_ demsat

keep year id trustgovt gender age educ edu faminc income employ workstatus polint leftright demsat
save "US_VSG_long.dta",replace